//ɂȂR[h http://www.jaist.ac.jp/~t-koba/cstips.php#msncommandlistener
using System;
using System.ComponentModel;
using System.Reflection;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading;
using System.Windows.Forms;

public class MsnCommandListener: IDisposable {
	#region Cxgp
	public delegate void OnReceiveMsnCommandEventHandler(ReceiveMsnCommandEventArgs e);

	public class ReceiveMsnCommandEventArgs: EventArgs {
		private string raw;
		private string sender;
		private CommandCategory category;
		private bool enable;
		private string format;
		private string[] datas;

		public enum CommandCategory {
			/// <summary>
			/// yɊւR}hł
			/// </summary>
			Music,
			/// <summary>
			/// Q[ɊւR}hł
			/// </summary>
			Games,
			/// <summary>
			/// ItBXɊւR}hł
			/// </summary>
			Office
		}

		/// <summary>
		/// ĂbZ[W擾܂B
		/// </summary>
		public string RawData {
			get {
				return raw;
			}
		}

		/// <summary>
		/// bZ[W̑M擾܂B
		/// </summary>
		public string Sender {
			get {
				return sender;
			}
		}

		/// <summary>
		/// bZ[W̎ނ擾܂B
		/// </summary>
		public CommandCategory Category {
			get {
				return category;
			}
		}

		/// <summary>
		/// bZ[W̗LE擾܂B
		/// </summary>
		public bool Enable {
			get {
				return enable;
			}
		}

		/// <summary>
		/// bZ[W̏擾܂B
		/// </summary>
		public string Format {
			get {
				return format;
			}
		}

		/// <summary>
		/// bZ[W̃f[^擾܂B
		/// </summary>
		public string[] Datas {
			get {
				return datas;
			}
		}

		public ReceiveMsnCommandEventArgs(string r, string s, CommandCategory c, bool e, string f, string[] d) {
			raw = r;
			sender = s;
			category = c;
			enable = e;
			format = f;
			datas = d;
		}

		public override string ToString() {
			StringBuilder sb = new StringBuilder();
			sb.Append("{Sender: " + sender);
			sb.Append(", Category: " + category.ToString());
			sb.Append(", Enable: " + enable.ToString());
			sb.Append(", Format: " + format);
			sb.Append(", Data:");
			for(int i = 0; i < datas.Length; i++) {
				sb.Append(" [" + i.ToString() + "]" + datas[i]);
			}
			sb.Append("}");
			return sb.ToString();
		}
	}
	#endregion

	private Thread app;
    private bool enable;

	private IntPtr hInstance;
    private IntPtr atom;
    private IntPtr hWnd;
	private WNDCLASSEX wcex;

	/// <summary>
	/// Windows Live MessengerւSendMessageM邩ǂ擾܂͐ݒ肵܂B
	/// </summary>
	public bool Enable {
		get {
			return enable;
		}
        set {
            if(value) {
                Start();
            } else {
                Stop();
            }
        }
	}

	/// <summary>
	/// Windows Live MessengerSendMessageMƂ̏ݒ肵܂B
	/// </summary>
    public event OnReceiveMsnCommandEventHandler ReceiveMsnCommand;

	/// <summary>
	/// Windows Live MessengerւSendMessageMJn܂B
	/// </summary>
    public void Start() {
        if(!enable) {
            app = new Thread(new ThreadStart(appLoop));
            app.Start();
        } else {
            throw new InvalidOperationException();
        }
    }

	/// <summary>
	/// Windows Live MessengerւSendMessage̎MI܂B
	/// </summary>
	public void Stop() {
		if(enable) {
			app.Abort();
			PostMessage(this.hWnd, 0x2, IntPtr.Zero, IntPtr.Zero);
		}
		else {
			throw new InvalidOperationException();
		}
	}

	#region Win32API
	private delegate IntPtr WindowProcedure(IntPtr hWnd, uint msg, IntPtr wParam, IntPtr lParam);

	[StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
	private struct WNDCLASSEX {
		[MarshalAs(UnmanagedType.U4)]
		public int cbSize;
		[MarshalAs(UnmanagedType.U4)]
		public int style;
		public WindowProcedure lpfnWndProc;
		public int cbClsExtra;
		public int cbWndExtra;
		public IntPtr hInstance;
		public IntPtr hIcon;
		public IntPtr hCursor;
		public IntPtr hbrBackground;
		public string lpszMenuName;
		public string lpszClassName;
		public IntPtr hIconSm;
	}

	[StructLayout(LayoutKind.Sequential)]
	public struct COPYDATASTRUCT {
		public int dwData;
		public int cbData;
		public IntPtr data;
	}

	[DllImport("user32.dll", EntryPoint = "RegisterClassEx", SetLastError = true, CharSet = CharSet.Ansi)]
	private static extern IntPtr RegisterClass(ref WNDCLASSEX lpwcx);

	[DllImport("user32.dll", EntryPoint = "CreateWindowEx", SetLastError = true, CharSet = CharSet.Ansi)]
	private static extern IntPtr CreateWindowEx(uint dwExStyle, string lpClassName, string lpWindowName, uint dwStyle, int x, int y, int nWidth, int nHeight, IntPtr hWndParent, IntPtr hMenu, IntPtr hInstance, IntPtr lpParam);

	[DllImport("user32.dll", EntryPoint = "GetMessageA", SetLastError = true, CharSet = CharSet.Ansi)]
	private static extern bool GetMessage(ref Message m, IntPtr hWnd, uint wMsgFilterMin, uint wMsgFilterMax);

	[DllImport("user32.dll")]
	private static extern bool TranslateMessage(ref Message m);

	[DllImport("user32.dll")]
	private static extern void DispatchMessage(ref Message m);

	[DllImport("user32.dll")]
	private static extern IntPtr DefWindowProc(IntPtr hWnd, uint msg, IntPtr wParam, IntPtr lParam);

	[DllImport("user32.dll")]
	private static extern IntPtr PostMessage(IntPtr hWnd, uint msg, IntPtr wParam, IntPtr lParam);

	[DllImport("user32.dll")]
	private static extern bool DestroyWindow(IntPtr hWnd);
	#endregion

	private void appLoop() {
		hInstance = Marshal.GetHINSTANCE(Assembly.GetExecutingAssembly().ManifestModule);
		//
		wcex = new WNDCLASSEX();
		wcex.style = 0;
		wcex.cbClsExtra = 0;
		wcex.cbWndExtra = 0;
		wcex.hbrBackground = IntPtr.Zero;
		wcex.hCursor = IntPtr.Zero;
		wcex.hIcon = IntPtr.Zero;
		wcex.hIconSm = IntPtr.Zero;
		wcex.lpszMenuName = null;
        wcex.lpfnWndProc = this.WndProc;
		wcex.hInstance = this.hInstance;
		wcex.lpszClassName = "MsnMsgrUIManager";
		wcex.cbSize = Marshal.SizeOf(wcex);

        this.atom = RegisterClass(ref wcex);
		if(atom == IntPtr.Zero) throw new Win32Exception(Marshal.GetLastWin32Error());
		this.hWnd = CreateWindowEx(0, "MsnMsgrUIManager", "", 0, 0, 0, 0, 0, IntPtr.Zero, IntPtr.Zero, this.hInstance, IntPtr.Zero);
		if(this.hWnd == IntPtr.Zero) throw new Win32Exception(Marshal.GetLastWin32Error());

        enable = true;
		try {
			Message m = new Message();
			IntPtr hwnd = this.hWnd;
			while(GetMessage(ref m, hwnd, 0, 0)) {
				TranslateMessage(ref m);
				DispatchMessage(ref m);
			}
		}
		catch(ThreadAbortException) {
		}
		enable = false;
		this.Dispose();
	}

	private IntPtr WndProc(IntPtr hWnd, uint msg, IntPtr wParam, IntPtr lParam) {
		switch(msg) {
			case 0x004A:
				COPYDATASTRUCT cds = (COPYDATASTRUCT)Marshal.PtrToStructure(lParam, typeof(COPYDATASTRUCT));
				string raw = Marshal.PtrToStringUni(cds.data, cds.cbData);
				string[] datas = raw.Split(new string[] { "\\0" }, StringSplitOptions.None);
				if(4 < datas.Length) {
					string s = datas[0];
					ReceiveMsnCommandEventArgs.CommandCategory c = ReceiveMsnCommandEventArgs.CommandCategory.Music;
					if(datas[1] == "Games") c = ReceiveMsnCommandEventArgs.CommandCategory.Games;
					if(datas[1] == "Office") c = ReceiveMsnCommandEventArgs.CommandCategory.Office;
					bool e = true;
					if(datas[2] == "0") e = false;
					string f = datas[3];
					string[] d = new string[datas.Length - 4];
					for(int i = 0; i < d.Length; i++) {
						d[i] = datas[i + 4];
					}

                    this.OnReceiveMsnCommand(new ReceiveMsnCommandEventArgs(raw, s, c, e, f, d));
				}
				break;
			default:
				return DefWindowProc(hWnd, msg, wParam, lParam);
		}
		return IntPtr.Zero;
	}

    /// <summary>
    /// ReceiveMsnCommandCxg𔭐܂B
    /// </summary>
    private void OnReceiveMsnCommand(ReceiveMsnCommandEventArgs args) {
        if(this.ReceiveMsnCommand != null) {
            this.ReceiveMsnCommand(args);
        }
    }

	#region IDisposable o
	public void Dispose() {
		if(this.hWnd != IntPtr.Zero) {
			DestroyWindow(this.hWnd);
			this.hWnd = IntPtr.Zero;
		}
	}
	#endregion
}
